CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "", "langPack", "Adobe Web Suite CS6", "Adobe Fireworks CS6", "12.0.0")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}"><File><InstallPath>[INSTALLDIR]\Adobe Fireworks CS6\English\Resources\Fireworks Resources.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "ValidationSig", "2g6PwoLd/r3eddT35qoBz41/DzSeFLc/O8fBCYkFXOOcpq0/LYvAGLcdrRCOvE/Ox4LWrv3HTbceNfvboyOFTxolSiRPHCz3ASoDjrP0S3bbhkG3z7EA/JU4j9fAW+XNmL2+FYYOQmwB3wy+tnCPpofnSLt4skLHyWHEEF67K4NeRa4OuJKzz1/b2wb/tQ1ygeRlICC5QesgWki4jvSv1/hb3itgWI3GEsog6QrLmh4xxJykoSgNwK0gBaDgOM5CZSGvkS2yRwmJFkdzMmzQ4r4HKqWA5dL2l6XY4YQsaT5TDfscz+fy6Zp4u1ok4+wu+bIGPlFLRkndgXQLAoWJ3qwmA8wvE3E/9rlviwJTUjZkbgu0Xa9jLHdTjPt09LFXJeZTLq7Rv7g17hc/CELk5DwX89Id31OQayJVCbC+RPGhNKYuxJdnv9ftPWbq8Nns8zjPdUty/gNGzmlKNR1dlyULaY6GUjcO4GBbeUp5lbW2sQmfBRbJ96hVSE5FAylP")
INSERT INTO Payloads VALUES	("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "Adobe Web Suite CS6", "Adobe Fireworks CS6_AdobeFireworks12en_USLanguagePack", "12.0.0", "langPack")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "KeyFolder", "[INSTALLDIR]/Adobe Fireworks CS6")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-03-30 22:53:25.102000</Property>
    <Property name="TargetName">AdobeFireworks12en_USLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}</Property>
    <Property name="ProductName">Adobe Fireworks CS6 English (en_US) Language Pack</Property>
    <Property name="ProductVersion">12.0.0</Property>
    <Property name="KeyFolder">[INSTALLDIR]/Adobe Fireworks CS6</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
    <Platform isFixed="0" name="OSX" folderName="">[AdobeProgramFiles]</Platform>
    <Platform isFixed="0" name="Win32" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>en_US</Language>
    <Language>en_AE</Language>
    <Language>fi_FI</Language>
    <Language>en_GB</Language>
    <Language>en_XM</Language>
    <Language>en_IL</Language>
    <Language>hu_HU</Language>
    <Language>uk_UA</Language>
    <Language>da_DK</Language>
    <Language>ko_KR</Language>
    <Language>zh_CN</Language>
    <Language>zh_TW</Language>
  </Languages><Satisfies>
    <ProductInfo>
    <Family>Adobe Web Suite CS6</Family>
    <ProductName>Adobe Fireworks CS6_AdobeFireworks12en_USLanguagePack</ProductName>
  <ProductVersion>12.0.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Channel enable="1" id="AdobeFireworksCS6-12.0.0-en_US">
    <DisplayName>Adobe Fireworks CS6 English (en_US) Language Pack</DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo minVersion="12.0.0">
          <Family>Adobe Web Suite CS6</Family>
          <ProductName>Adobe Fireworks CS6</ProductName>
        </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="4663423" sysDriveSize="1630"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>4663423</TotalSize>
      <MaxPathComponent>/Adobe Fireworks CS6/English/Movies/resources/images\background-list.png</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>1630</TotalSize>
      <MaxPathComponent>/HelpCfg/en_US\Fireworks.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="1630"/>
      <Asset flag="1" name="Assets1_1" size="4663423"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="en_US">12.0.0</Value>
      <Value lang="en_AE">12.0.0</Value>
      <Value lang="fi_FI">12.0.0</Value>
      <Value lang="en_GB">12.0.0</Value>
      <Value lang="en_XM">12.0.0</Value>
      <Value lang="en_IL">12.0.0</Value>
      <Value lang="hu_HU">12.0.0</Value>
      <Value lang="uk_UA">12.0.0</Value>
      <Value lang="da_DK">12.0.0</Value>
      <Value lang="ko_KR">12.0.0</Value>
      <Value lang="zh_CN">12.0.0</Value>
      <Value lang="zh_TW">12.0.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="en_US">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="en_AE">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="fi_FI">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="en_GB">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="en_XM">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="en_IL">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="hu_HU">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="uk_UA">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="da_DK">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="ko_KR">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="zh_CN">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
      <Value lang="zh_TW">Adobe Fireworks CS6 English (en_US) Language Pack</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0", "ChannelID", "AdobeFireworksCS6-12.0.0-en_US")
INSERT INTO PayloadData VALUES("{05E1E278-7A8D-11E1-A0B9-FC0245DB7244}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeFireworksCS6-12.0.0-en_US">
    <DisplayName>Adobe Fireworks CS6 English (en_US) Language Pack</DisplayName>
  </Channel>')
